######################################################################
#
# Macro Name    : e:/ranibandh graphite block/bh.tcl
#
# Version       : Surpac 7.7.1 (x64)
#
# Creation Date : Wed Jun  4 15:34:43 2025
#
# Description   : 
#
######################################################################

set status [ SclFunction "CHECK DATABASE CONNECTED" {
  databasesession="GeologyDatabase"
  databasepurpose="drillholes"
  databasehandle="GEOLOGY"
  databaseEditable=true
}]

set status [ SclFunction "GET DATABASE HANDLE" {
  sessionType="GeologyDatabase"
  DatabaseHandle="GEOLOGY"
  DatabaseType="drillholes"
  DatabaseName="bh"
  DatabaseEditable=true
  result=1
}]

set status [ SclFunction "DRILLHOLE ATTRIBUTES" {
  trace_colour="r=1.0 g=1.0 b=0.2"
  trace_thickness="1"
  table="collar"
  field="hole_id"
  tick_mark_weight="1"
  rescale="true"
  add_constraint="false"
  cylinder_style="no cylinders"
  cylinder_radius="1.000"
  cylinder_maximum="50.0"
  show_collars="true"
}]

set status [ SclFunction "DRILLHOLE COLLARS" {
  show_collars="true"
  collar_marker="(O)"
  collar_marker_size="0.5"
  position="along path"
  collar_offset="0.0"
  fld={
    "hole_id"
    "max_depth"
  }
  decimals={
    "-1"
    "2"
  }
  font_style={
    "Default"
    "Default"
  }
  font_size={
    "1.0"
    "1.0"
  }
  font_units={
    "oru"
    "oru"
  }
  label_position={
    "collar"
    "eoh"
  }
  num_rows="2"
}]

set status [ SclFunction "DRILLHOLE GEOLOGY" {
  tbl={
    "assay"
  }
  fld={
    "fc"
  }
  position={
    "right"
  }
  size={
    "1.0"
  }
  offset={
    "0.0"
  }
  num_rows="1"
}]

set status [ SclFunction "DRILLHOLE LABELS" {
  tick_length="1.0"
  tbl={
    "assay"
  }
  fld={
    "fc"
  }
  position={
    "right"
  }
  offset={
    "1.0"
  }
  decimals={
    "2"
  }
  use_styles={
    "true"
  }
  colour={
    ""
  }
  font_style={
    "Default"
  }
  font_size={
    "1.0"
  }
  font_units={
    "oru"
  }
  alignment={
    "left"
  }
  combine={
    "true"
  }
  minValue={
    ""
  }
  maxValue={
    ""
  }
  selectable={
    "true"
  }
  num_rows="1"
}]

set status [ SclFunction "DRILLHOLE GRAPHS" {
  num_rows="0"
}]

set status [ SclFunction "DRILLHOLE DEPTH MARKERS" {
  position="left"
  offset="5.0"
  decimals="2"
  use_styles="false"
  colour=""
  font_style="Default"
  font_size="1.000"
  font_units="oru"
  alignment="right"
  major="10.0"
  minor="0.0"
  display="false"
  major_length="3.0"
  minor_length="1.0"
}]

set status [ SclFunction "DRILLHOLE APPARENT DIP MARKERS" {
  num_rows="0"
}]

set status [ SclFunction "CHECK DATABASE CONNECTED" {
  databasepurpose="drillholes"
  databasesession="GeologyDatabase"
  databasehandle="GEOLOGY"
  databaseEditable=true
}]

set status [ SclFunction "EDIT DATABASE STYLES" {
  databasetype="drillholes"
  StylesTree="bh=bh\u007bassay=assay\u007bdepth_from=StyleType=Numeric\u007b\u007d\u007d\u007bdepth_to=StyleType=Numeric\u007b\u007d\u007d\u007bfc=StyleType=Numeric;Min=2.1;Max=11.390000000000002;\u007b2.1  -  11.390000000000002=GraphicsColour=red;GraphicsPattern=solid;PlottingColour=red;PlottingPattern=solid;LineStyle=line_colour~periwinkle!line_weight~1!line_pattern~---!line_join~>!line_end~|;MarkerStyle=marker_symbol~/.\\!marker_size~0.5;\u007d\u007d\u007bhole_id=StyleType=Character\u007b\u007d\u007d\u007bsamp_id=StyleType=Character\u007b\u007d\u007d\u007bx_from=StyleType=Numeric\u007b\u007d\u007d\u007bx_to=StyleType=Numeric\u007b\u007d\u007d\u007by_from=StyleType=Numeric\u007b\u007d\u007d\u007by_to=StyleType=Numeric\u007b\u007d\u007d\u007bz_from=StyleType=Numeric\u007b\u007d\u007d\u007bz_to=StyleType=Numeric\u007b\u007d\u007d\u007d\u007bcollar=collar\u007bhole_id=StyleType=Character\u007b\u007d\u007d\u007bhole_path=StyleType=Character\u007b\u007d\u007d\u007bmax_depth=StyleType=Numeric\u007b\u007d\u007d\u007bx=StyleType=Numeric\u007b\u007d\u007d\u007by=StyleType=Numeric\u007b\u007d\u007d\u007bz=StyleType=Numeric\u007b\u007d\u007d\u007d\u007blitho=litho\u007bdepth_from=StyleType=Numeric\u007b\u007d\u007d\u007bdepth_to=StyleType=Numeric\u007b\u007d\u007d\u007bhole_id=StyleType=Character\u007b\u007d\u007d\u007blcode=StyleType=Character\u007b\u007d\u007d\u007bsamp_id=StyleType=Character\u007b\u007d\u007d\u007bx_from=StyleType=Numeric\u007b\u007d\u007d\u007bx_to=StyleType=Numeric\u007b\u007d\u007d\u007by_from=StyleType=Numeric\u007b\u007d\u007d\u007by_to=StyleType=Numeric\u007b\u007d\u007d\u007bz_from=StyleType=Numeric\u007b\u007d\u007d\u007bz_to=StyleType=Numeric\u007b\u007d\u007d\u007d"
}]

set status [ SclFunction "LAYER OPTIONS" {
  layername="topo.dtm"
  visible="false"
}]

